/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;

    private static final long dlopen(String string, int n) {
        Foreign foreign = Foreign.getInstance();
        try {
            return foreign.dlopen(string, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            lastError.set(unsatisfiedLinkError.getMessage());
            return 0L;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String string, int n) {
        Library library;
        if (string == null) {
            return Library.getDefault();
        }
        WeakReference<Library> weakReference = cache.get(string);
        Library library2 = library = weakReference != null ? (Library)weakReference.get() : null;
        if (library != null) {
            return library;
        }
        library = Library.openLibrary(string, n);
        if (library == null) {
            return null;
        }
        cache.put(string, new WeakReference<Library>(library));
        return library;
    }

    public static final Library openLibrary(String string, int n) {
        long l;
        if (n == 0) {
            n = 5;
        }
        return (l = Library.dlopen(string, n)) != 0L ? new Library(string, l) : null;
    }

    private Library(String string, long l) {
        this.name = string;
        this.handle = l;
    }

    public final long getSymbolAddress(String string) {
        Foreign foreign = Foreign.getInstance();
        try {
            return foreign.dlsym(this.handle, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            lastError.set(foreign.dlerror());
            return 0L;
        }
    }

    public static final String getLastError() {
        String string = lastError.get();
        return string != null ? string : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.getInstance().dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    static /* synthetic */ long access$000(String string, int n) {
        return Library.dlopen(string, n);
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = new Library(null, Library.access$000(null, 9));

        private DefaultLibrary() {
        }
    }
}

